/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImplKt;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcIdentifierManager;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 d2\u00020\u0001:\u0002edB\u0017\u0012\u0006\u0010a\u001a\u00020\u0018\u0012\u0006\u0010F\u001a\u00020\u0011\u00a2\u0006\u0004\bb\u0010cJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J5\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ5\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t0\b2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\fJ4\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\"\u0004\b\u0000\u0010\u000f2\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0002\b\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0004J\u0017\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\tH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ/\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010!\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\"\u0010#JU\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b*\u00020$2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0%0\u0010H\u0002\u00a2\u0006\u0004\b'\u0010(R\u001e\u0010)\u001a\u0004\u0018\u00010\u00188B@\u0002X\u0082\u000e\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010,R\u001b\u00102\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u0010,R\u0014\u00104\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010,R\u001b\u00107\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00100\u001a\u0004\b6\u0010,R\u001b\u0010<\u001a\u0002088VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u00100\u001a\u0004\b:\u0010;R<\u0010?\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t0=j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t`>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u001b\u0010E\u001a\u00020A8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u00100\u001a\u0004\bC\u0010DR\u0017\u0010F\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001dR\u001b\u0010O\u001a\u00020K8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u00100\u001a\u0004\bM\u0010NR\u001b\u0010R\u001a\u00020K8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u00100\u001a\u0004\bQ\u0010NR\u001b\u0010U\u001a\u00020K8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bS\u00100\u001a\u0004\bT\u0010NR&\u0010X\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u001b\u0010[\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bY\u00100\u001a\u0004\bZ\u0010,R\u001b\u0010`\u001a\u00020\\8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b]\u00100\u001a\u0004\b^\u0010_\u00a8\u0006f"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "", "cleanCache", "()V", "", "Lorg/jetbrains/exposed/sql/Table;", "tables", "", "", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "columns", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "Lorg/jetbrains/exposed/sql/Index;", "existingIndices", "T", "Lkotlin/Function1;", "Ljava/sql/DatabaseMetaData;", "Lkotlin/ExtensionFunctionType;", "body", "Lkotlin/Lazy;", "lazyMetadata", "(Lkotlin/jvm/functions/Function1;)Lkotlin/Lazy;", "resetCurrentScheme", "", "defaultValue", "sanitizedDefault", "(Ljava/lang/String;)Ljava/lang/String;", "schemaNames", "()Ljava/util/List;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tableConstraints", "(Ljava/util/List;)Ljava/util/Map;", "scheme", "tableNamesFor", "(Ljava/lang/String;)Ljava/util/List;", "Ljava/sql/ResultSet;", "Lkotlin/Pair;", "extract", "extractColumns", "(Ljava/sql/ResultSet;[Lorg/jetbrains/exposed/sql/Table;Lkotlin/jvm/functions/Function1;)Ljava/util/Map;", "_currentScheme", "Ljava/lang/String;", "get_currentScheme", "()Ljava/lang/String;", "getCurrentScheme", "currentScheme", "databaseDialectName$delegate", "Lkotlin/Lazy;", "getDatabaseDialectName", "databaseDialectName", "getDatabaseName", "databaseName", "databaseProductVersion$delegate", "getDatabaseProductVersion", "databaseProductVersion", "", "defaultIsolationLevel$delegate", "getDefaultIsolationLevel", "()I", "defaultIsolationLevel", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "existingIndicesCache", "Ljava/util/HashMap;", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager", "metadata", "Ljava/sql/DatabaseMetaData;", "getMetadata", "()Ljava/sql/DatabaseMetaData;", "getSchemaNames", "", "supportsAlterTableWithAddColumn$delegate", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn", "supportsMultipleResultSets$delegate", "getSupportsMultipleResultSets", "supportsMultipleResultSets", "supportsSelectForUpdate$delegate", "getSupportsSelectForUpdate", "supportsSelectForUpdate", "getTableNames", "()Ljava/util/Map;", "tableNames", "url$delegate", "getUrl", "url", "Ljava/math/BigDecimal;", "version$delegate", "getVersion", "()Ljava/math/BigDecimal;", "version", "database", "<init>", "(Ljava/lang/String;Ljava/sql/DatabaseMetaData;)V", "Companion", "CachableMapWithDefault", "exposed-jdbc"})
public final class JdbcDatabaseMetadataImpl
extends ExposedDatabaseMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseMetaData metadata;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy databaseDialectName$delegate;
    @NotNull
    private final Lazy databaseProductVersion$delegate;
    @NotNull
    private final Lazy defaultIsolationLevel$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    @Nullable
    private String _currentScheme;
    @NotNull
    private final HashMap<Table, List<Index>> existingIndicesCache;
    @NotNull
    private static final ConcurrentHashMap<String, JdbcIdentifierManager> identityManagerCache = new ConcurrentHashMap();

    public JdbcDatabaseMetadataImpl(@NotNull String database, @NotNull DatabaseMetaData metadata2) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        super(database);
        this.metadata = metadata2;
        this.url$delegate = this.lazyMetadata(url.2.INSTANCE);
        this.version$delegate = this.lazyMetadata(version.2.INSTANCE);
        this.databaseDialectName$delegate = this.lazyMetadata(databaseDialectName.2.INSTANCE);
        this.databaseProductVersion$delegate = this.lazyMetadata(databaseProductVersion.2.INSTANCE);
        this.defaultIsolationLevel$delegate = this.lazyMetadata(defaultIsolationLevel.2.INSTANCE);
        this.supportsAlterTableWithAddColumn$delegate = this.lazyMetadata(supportsAlterTableWithAddColumn.2.INSTANCE);
        this.supportsMultipleResultSets$delegate = this.lazyMetadata(supportsMultipleResultSets.2.INSTANCE);
        this.supportsSelectForUpdate$delegate = this.lazyMetadata(supportsSelectForUpdate.2.INSTANCE);
        this.identifierManager$delegate = this.lazyMetadata(identifierManager.2.INSTANCE);
        this.existingIndicesCache = new HashMap();
    }

    @NotNull
    public final DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public String getUrl() {
        Lazy lazy2 = this.url$delegate;
        Object object = lazy2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-url>(...)");
        return (String)object;
    }

    @Override
    @NotNull
    public BigDecimal getVersion() {
        Lazy lazy2 = this.version$delegate;
        return (BigDecimal)lazy2.getValue();
    }

    @Override
    @NotNull
    public String getDatabaseDialectName() {
        Lazy lazy2 = this.databaseDialectName$delegate;
        return (String)lazy2.getValue();
    }

    private final String getDatabaseName() {
        String string = this.getDatabaseDialectName();
        return (Intrinsics.areEqual((Object)string, (Object)"mysql") ? true : Intrinsics.areEqual((Object)string, (Object)"mariadb")) ? this.getCurrentScheme() : this.getDatabase();
    }

    @Override
    @NotNull
    public String getDatabaseProductVersion() {
        Lazy lazy2 = this.databaseProductVersion$delegate;
        return (String)lazy2.getValue();
    }

    @Override
    public int getDefaultIsolationLevel() {
        Lazy lazy2 = this.defaultIsolationLevel$delegate;
        return ((Number)lazy2.getValue()).intValue();
    }

    @Override
    public boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy2 = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsMultipleResultSets() {
        Lazy lazy2 = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsSelectForUpdate() {
        Lazy lazy2 = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    @NotNull
    public IdentifierManagerApi getIdentifierManager() {
        Lazy lazy2 = this.identifierManager$delegate;
        Object object = lazy2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-identifierManager>(...)");
        return (IdentifierManagerApi)object;
    }

    private final String get_currentScheme() {
        block14: {
            String string;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl;
            if (this._currentScheme != null) break block14;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl2 = this;
            try {
                String string2;
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                switch (this.getDatabaseDialectName()) {
                    case "mariadb": 
                    case "mysql": {
                        string2 = this.metadata.getConnection().getCatalog();
                        if (string2 != null) break;
                        string2 = "";
                        break;
                    }
                    case "oracle": {
                        string2 = this.getDatabaseName();
                        break;
                    }
                    default: {
                        string2 = this.metadata.getConnection().getSchema();
                        if (string2 != null) break;
                        string2 = "";
                    }
                }
                string = string2;
            }
            catch (Throwable e) {
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = "";
            }
            jdbcDatabaseMetadataImpl._currentScheme = string;
        }
        String string = this._currentScheme;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @NotNull
    public String getCurrentScheme() {
        String string = this.get_currentScheme();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    public void resetCurrentScheme() {
        this._currentScheme = null;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getTableNames() {
        return new CachableMapWithDefault(null, (Function1)new Function1<String, List<? extends String>>(this){
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull String schemeName) {
                Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
                return JdbcDatabaseMetadataImpl.access$tableNamesFor(this.this$0, schemeName);
            }
        }, 1, null);
    }

    private final List<String> tableNamesFor(String scheme2) {
        Pair pair;
        DatabaseMetaData $this$tableNamesFor_u24lambda_u2d1 = this.metadata;
        boolean bl = false;
        boolean useCatalogInsteadOfScheme = DefaultKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            pair = TuplesKt.to((Object)scheme2, (Object)"%");
        } else if (DefaultKt.getCurrentDialect() instanceof OracleDialect) {
            pair = TuplesKt.to((Object)this.getDatabaseName(), (Object)this.getDatabaseName());
        } else {
            CharSequence charSequence;
            String string = this.getDatabaseName();
            CharSequence charSequence2 = scheme2;
            if (charSequence2.length() == 0) {
                String string2 = string;
                boolean bl2 = false;
                charSequence = "%";
                string = string2;
            } else {
                charSequence = charSequence2;
            }
            pair = TuplesKt.to((Object)string, (Object)charSequence);
        }
        Pair pair2 = pair;
        String catalogName = (String)pair2.component1();
        String schemeName = (String)pair2.component2();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = $this$tableNamesFor_u24lambda_u2d1.getTables(catalogName, schemeName, "%", stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
        return JdbcDatabaseMetadataImplKt.access$iterate(resultSet, (Function1)new Function1<ResultSet, String>(useCatalogInsteadOfScheme, this){
            final /* synthetic */ boolean $useCatalogInsteadOfScheme;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$useCatalogInsteadOfScheme = $useCatalogInsteadOfScheme;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ResultSet $this$iterate) {
                String it;
                String string;
                Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
                String string2 = $this$iterate.getString("TABLE_NAME");
                Intrinsics.checkNotNull((Object)string2);
                String tableName = string2;
                if (this.$useCatalogInsteadOfScheme) {
                    String string3 = $this$iterate.getString("TABLE_CAT");
                    if (string3 == null) {
                        string = null;
                    } else {
                        it = string3;
                        boolean bl = false;
                        string = it + '.' + tableName;
                    }
                } else {
                    String string4 = $this$iterate.getString("TABLE_SCHEM");
                    if (string4 == null) {
                        string = null;
                    } else {
                        it = string4;
                        boolean bl = false;
                        string = it + '.' + tableName;
                    }
                }
                String string5 = string;
                String fullTableName = string5 == null ? tableName : string5;
                return this.this$0.getIdentifierManager().inProperCase(fullTableName);
            }
        });
    }

    @Override
    @NotNull
    public List<String> getSchemaNames() {
        return this.schemaNames();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> schemaNames() {
        void $this$mapTo$iv$iv;
        List list2;
        ResultSet resultSet;
        DatabaseMetaData $this$schemaNames_u24lambda_u2d3 = this.metadata;
        boolean bl = false;
        boolean useCatalogInsteadOfScheme = DefaultKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            resultSet = $this$schemaNames_u24lambda_u2d3.getCatalogs();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"catalogs");
            list2 = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.1.INSTANCE);
        } else {
            resultSet = $this$schemaNames_u24lambda_u2d3.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"schemas");
            list2 = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.2.INSTANCE);
        }
        List schemas2 = list2;
        Iterable $this$map$iv = schemas2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(identifierManagerApi.inProperCase((String)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Table, List<ColumnMetadata>> extractColumns(ResultSet $this$extractColumns, Table[] tables, Function1<? super ResultSet, Pair<String, ColumnMetadata>> extract) {
        void $this$associateByTo$iv$iv;
        Table[] $this$associateBy$iv = tables;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        Table[] tableArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            void var15_18 = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.nameInDatabaseCase(), element$iv$iv);
        }
        Map mapping = destination$iv$iv;
        HashMap result2 = new HashMap();
        while ($this$extractColumns.next()) {
            Object object;
            Table t;
            Pair pair = (Pair)extract.invoke((Object)$this$extractColumns);
            String tableName = (String)pair.component1();
            ColumnMetadata columnMetadata = (ColumnMetadata)pair.component2();
            if ((Table)mapping.get(tableName) == null) continue;
            boolean bl = false;
            Map $this$getOrPut$iv = result2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(t);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(t, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(columnMetadata);
        }
        return result2;
    }

    @Override
    @NotNull
    public Map<Table, List<ColumnMetadata>> columns(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        ResultSet rs = this.metadata.getColumns(this.getDatabaseName(), this.getCurrentScheme(), "%", "%");
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        Map<Table, List<ColumnMetadata>> result2 = this.extractColumns(rs, tables, (Function1<? super ResultSet, Pair<String, ColumnMetadata>>)((Function1)new Function1<ResultSet, Pair<? extends String, ? extends ColumnMetadata>>(this){
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<String, ColumnMetadata> invoke(@NotNull ResultSet it) {
                String string;
                void it2;
                int n;
                String string2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string3 = it.getString("COLUMN_DEF");
                if (string3 == null) {
                    string2 = null;
                } else {
                    String string4 = string3;
                    JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl = this.this$0;
                    String it3 = string4;
                    n = 0;
                    string2 = JdbcDatabaseMetadataImpl.access$sanitizedDefault(jdbcDatabaseMetadataImpl, it3);
                }
                String defaultDbValue = string2;
                boolean autoIncrement = Intrinsics.areEqual((Object)it.getString("IS_AUTOINCREMENT"), (Object)"YES");
                int type = it.getInt("DATA_TYPE");
                Object object = it.getString("COLUMN_NAME");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.getString(\"COLUMN_NAME\")");
                String string5 = object;
                object = it.getInt("COLUMN_SIZE");
                n = ((Number)object).intValue();
                boolean bl = it.getBoolean("NULLABLE");
                int n2 = type;
                String string6 = string5;
                boolean bl22 = false;
                Object object2 = it2 != false;
                String string7 = string6;
                int n3 = n2;
                boolean bl3 = bl;
                Object object3 = ((Boolean)object2).booleanValue() ? object : null;
                boolean bl4 = autoIncrement;
                String string8 = defaultDbValue;
                if (string8 == null) {
                    string = null;
                } else {
                    String string9;
                    String bl22 = string9 = string8;
                    boolean bl5 = bl4;
                    object2 = object3;
                    bl = bl3;
                    n2 = n3;
                    string6 = string7;
                    boolean bl6 = false;
                    boolean bl7 = !autoIncrement;
                    string7 = string6;
                    n3 = n2;
                    bl3 = bl;
                    object3 = object2;
                    bl4 = bl5;
                    string = bl7 ? string9 : null;
                }
                String string10 = string;
                boolean bl8 = bl4;
                Object object4 = object3;
                boolean bl9 = bl3;
                int n4 = n3;
                String string11 = string7;
                ColumnMetadata columnMetadata = new ColumnMetadata(string11, n4, bl9, (Integer)object4, bl8, string10);
                return TuplesKt.to((Object)it.getString("TABLE_NAME"), (Object)columnMetadata);
            }
        }));
        rs.close();
        return result2;
    }

    private final String sanitizedDefault(String defaultValue) {
        String string;
        DatabaseDialect databaseDialect = DefaultKt.getCurrentDialect();
        if (databaseDialect instanceof SQLServerDialect) {
            char[] cArray = new char[]{'(', ')', '\''};
            string = StringsKt.trim((String)defaultValue, (char[])cArray);
        } else if (databaseDialect instanceof OracleDialect) {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)defaultValue)).toString(), (char[])cArray);
        } else if (databaseDialect instanceof MysqlDialect) {
            char[] cArray = new char[]{'\''};
            string = ((Object)StringsKt.trim((CharSequence)StringsKt.trim((String)StringsKt.substringAfter$default((String)defaultValue, (String)"b'", null, (int)2, null), (char[])cArray))).toString();
        } else {
            char[] cArray = new char[]{'\''};
            string = ((Object)StringsKt.trim((CharSequence)StringsKt.trim((String)defaultValue, (char[])cArray))).toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        int n = 0;
        int n2 = tables.length;
        while (n < n2) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterNotTo$iv$iv;
            void $this$associateByTo$iv$iv;
            Object value$iv;
            Object column;
            Table table = tables[n];
            ++n;
            String tableName = table.nameInDatabaseCase();
            Transaction transaction2 = TransactionManager.Companion.current();
            Map $this$getOrPut$iv = this.existingIndicesCache;
            boolean $i$f$getOrPut = false;
            Object value$iv2 = $this$getOrPut$iv.get(table);
            if (value$iv2 != null) continue;
            boolean bl = false;
            ResultSet rs = this.getMetadata().getPrimaryKeys(this.getDatabaseName(), this.getCurrentScheme(), tableName);
            boolean bl2 = false;
            ArrayList names = new ArrayList();
            while (rs.next()) {
                String it;
                if (rs.getString("PK_NAME") == null) continue;
                boolean bl3 = false;
                ((Collection)names).add(it);
            }
            rs.close();
            ArrayList pkNames = names;
            ResultSet rs2 = this.getMetadata().getIndexInfo(this.getDatabaseName(), this.getCurrentScheme(), tableName, false, false);
            HashMap tmpIndices = new HashMap();
            while (rs2.next()) {
                Object object;
                void $this$getOrPut$iv2;
                String it;
                if (rs2.getString("INDEX_NAME") == null) continue;
                boolean bl4 = false;
                IdentifierManagerApi identifierManagerApi = transaction2.getDb().getIdentifierManager();
                String string = rs2.getString("COLUMN_NAME");
                Intrinsics.checkNotNull((Object)string);
                column = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string);
                boolean isUnique = !rs2.getBoolean("NON_UNIQUE");
                Map map2 = tmpIndices;
                Pair key$iv = TuplesKt.to((Object)it, (Object)isUnique);
                boolean $i$f$getOrPut2 = false;
                value$iv = $this$getOrPut$iv2.get(key$iv);
                if (value$iv == null) {
                    boolean bl5 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv2.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(column);
            }
            rs2.close();
            Iterable $this$associateBy$iv = table.getColumns();
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            column = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                value$iv = (Column)element$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl6 = false;
                map3.put(transaction2.identity((Column<?>)it), element$iv$iv);
            }
            Map tColumns = destination$iv$iv;
            Map $this$filterNot$iv = tmpIndices;
            boolean $i$f$filterNot = false;
            Map capacity$iv22 = $this$filterNot$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator $i$f$associateByTo22 = $this$filterNotTo$iv$iv.entrySet().iterator();
            while ($i$f$associateByTo22.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = $i$f$associateByTo22.next();
                boolean bl7 = false;
                if (pkNames.contains(((Pair)it.getKey()).getFirst())) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filterNot$iv = destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Index index;
                List list2;
                List list3;
                void $this$mapNotNullTo$iv$iv2;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl8 = false;
                Map.Entry $dstr$index$columns = element$iv$iv;
                boolean bl9 = false;
                Pair index2 = (Pair)$dstr$index$columns.getKey();
                List columns2 = (List)$dstr$index$columns.getValue();
                Iterable $this$mapNotNull$iv2 = CollectionsKt.distinct((Iterable)columns2);
                boolean $i$f$mapNotNull2 = false;
                Iterable iterable = $this$mapNotNull$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    Column it$iv$iv;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator3.next();
                    boolean bl10 = false;
                    String cn = (String)element$iv$iv2;
                    boolean bl11 = false;
                    if ((Column)tColumns.get(cn) == null) continue;
                    boolean bl12 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                List c = list3 = (List)destination$iv$iv3;
                boolean bl13 = false;
                List list4 = list2 = c.size() == columns2.size() ? list3 : null;
                if (list2 == null) {
                    index = null;
                } else {
                    c = list2;
                    boolean bl14 = false;
                    index = new Index(c, (Boolean)index2.getSecond(), (String)index2.getFirst(), null, 8, null);
                }
                if (index == null) continue;
                Index it$iv$iv = index;
                boolean bl15 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv2;
            $this$getOrPut$iv.put(table, answer$iv);
        }
        return new HashMap(this.existingIndicesCache);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized Map<String, List<ForeignKeyConstraint>> tableConstraints(@NotNull List<? extends Table> tables) {
        Map map2;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv2;
            map2 = destination$iv$iv;
            boolean bl2 = false;
            map2.put(it.nameInDatabaseCase(), element$iv$iv2);
        }
        Map allTables = destination$iv$iv;
        Iterable $this$associateWith$iv = allTables.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list$iv$iv;
            Object answer$iv$iv$iv;
            ForeignKeyConstraint it;
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv;
            void table;
            Object element$iv$iv2;
            element$iv$iv2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            Object bl2 = this.getMetadata().getImportedKeys(this.getDatabaseName(), this.getCurrentScheme(), (String)table);
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"metadata.getImportedKeys\u2026me, currentScheme, table)");
            bl2 = CollectionsKt.filterNotNull((Iterable)JdbcDatabaseMetadataImplKt.access$iterate((ResultSet)bl2, (Function1)new Function1<ResultSet, ForeignKeyConstraint>(this, (Map<String, ? extends Table>)allTables){
                final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
                final /* synthetic */ Map<String, Table> $allTables;
                {
                    this.this$0 = $receiver;
                    this.$allTables = $allTables;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ForeignKeyConstraint invoke(@NotNull ResultSet $this$iterate) {
                    T element$iv3;
                    String constraintName;
                    Column fromColumn;
                    block4: {
                        void $this$first$iv;
                        Object v3;
                        Object element$iv22;
                        block3: {
                            void $this$firstOrNull$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
                            String string = $this$iterate.getString("FKTABLE_NAME");
                            Intrinsics.checkNotNull((Object)string);
                            String fromTableName = string;
                            IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                            String string2 = $this$iterate.getString("FKCOLUMN_NAME");
                            Intrinsics.checkNotNull((Object)string2);
                            String fromColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string2);
                            Iterable iterable = ((Table)MapsKt.getValue(this.$allTables, (Object)fromTableName)).getColumns();
                            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl = this.this$0;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv22 : $this$firstOrNull$iv) {
                                Column it = (Column)element$iv22;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)jdbcDatabaseMetadataImpl.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.getName()), (Object)fromColumnName)) continue;
                                v3 = element$iv22;
                                break block3;
                            }
                            v3 = null;
                        }
                        Column column = v3;
                        if (column == null) {
                            return null;
                        }
                        fromColumn = column;
                        String string = $this$iterate.getString("FK_NAME");
                        Intrinsics.checkNotNull((Object)string);
                        constraintName = string;
                        String string3 = $this$iterate.getString("PKTABLE_NAME");
                        Intrinsics.checkNotNull((Object)string3);
                        String targetTableName = string3;
                        IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                        IdentifierManagerApi identifierManagerApi2 = this.this$0.getIdentifierManager();
                        String string4 = $this$iterate.getString("PKCOLUMN_NAME");
                        Intrinsics.checkNotNull((Object)string4);
                        String targetColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(identifierManagerApi2.inProperCase(string4));
                        Iterable iterable = ((Table)MapsKt.getValue(this.$allTables, (Object)targetTableName)).getColumns();
                        element$iv22 = this.this$0;
                        boolean $i$f$first = false;
                        for (T element$iv3 : $this$first$iv) {
                            Column it = (Column)element$iv3;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)((JdbcDatabaseMetadataImpl)element$iv22).getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase()), (Object)targetColumnName)) continue;
                            break block4;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Column targetColumn = (Column)element$iv3;
                    ReferenceOption constraintUpdateRule = ReferenceOption.Companion.resolveRefOptionFromJdbc($this$iterate.getInt("UPDATE_RULE"));
                    ReferenceOption constraintDeleteRule = ReferenceOption.Companion.resolveRefOptionFromJdbc($this$iterate.getInt("DELETE_RULE"));
                    return new ForeignKeyConstraint(targetColumn, fromColumn, constraintUpdateRule, constraintDeleteRule, constraintName);
                }
            }));
            boolean $i$f$groupBy = false;
            void var14_20 = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv3 : $this$groupByTo$iv$iv) {
                Object object;
                it = (ForeignKeyConstraint)element$iv$iv3;
                boolean bl3 = false;
                String key$iv$iv = it.getFkName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv3);
            }
            $this$groupBy$iv = destination$iv$iv2.values();
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (List)item$iv$iv;
                Object object = destination$iv$iv2;
                boolean bl5 = false;
                Iterable $this$reduce$iv = (Iterable)((Object)it);
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    answer$iv$iv$iv = (ForeignKeyConstraint)iterator$iv.next();
                    ForeignKeyConstraint p0 = (ForeignKeyConstraint)accumulator$iv;
                    boolean bl6 = false;
                    accumulator$iv = p0.plus((ForeignKeyConstraint)p1);
                }
                object.add((ForeignKeyConstraint)accumulator$iv);
            }
            List list2 = (List)destination$iv$iv2;
            map2.put(t, list2);
        }
        return result$iv;
    }

    @Override
    public synchronized void cleanCache() {
        this.existingIndicesCache.clear();
    }

    private final <T> Lazy<T> lazyMetadata(Function1<? super DatabaseMetaData, ? extends T> body) {
        return LazyKt.lazy((Function0)new Function0<T>(body, this){
            final /* synthetic */ Function1<DatabaseMetaData, T> $body;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$body = $body;
                this.this$0 = $receiver;
                super(0);
            }

            public final T invoke() {
                return (T)this.$body.invoke((Object)this.this$0.getMetadata());
            }
        });
    }

    public static final /* synthetic */ List access$tableNamesFor(JdbcDatabaseMetadataImpl $this, String scheme2) {
        return $this.tableNamesFor(scheme2);
    }

    public static final /* synthetic */ String access$sanitizedDefault(JdbcDatabaseMetadataImpl $this, String defaultValue) {
        return $this.sanitizedDefault(defaultValue);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getIdentityManagerCache$cp() {
        return identityManagerCache;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003B1\u0012\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001a\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0004\b\t\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0004\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\f\u0010\rR#\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R&\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00140\u00138\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u001d8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010!8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault;", "K", "V", "", "key", "", "containsKey", "(Ljava/lang/Object;)Z", "value", "containsValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "()Z", "Lkotlin/Function1;", "default", "Lkotlin/jvm/functions/Function1;", "getDefault", "()Lkotlin/jvm/functions/Function1;", "", "", "getEntries", "()Ljava/util/Set;", "entries", "getKeys", "keys", "", "map", "Ljava/util/Map;", "", "getSize", "()I", "size", "", "getValues", "()Ljava/util/Collection;", "values", "<init>", "(Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "exposed-jdbc"})
    private final class CachableMapWithDefault<K, V>
    implements Map<K, V>,
    KMappedMarker {
        @NotNull
        private final Map<K, V> map;
        @NotNull
        private final Function1<K, V> default;

        public CachableMapWithDefault(@NotNull Map<K, V> map2, Function1<? super K, ? extends V> function1) {
            Intrinsics.checkNotNullParameter((Object)JdbcDatabaseMetadataImpl.this, (String)"this$0");
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            Intrinsics.checkNotNullParameter(function1, (String)"default");
            this.map = map2;
            this.default = function1;
        }

        public /* synthetic */ CachableMapWithDefault(Map map2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = new LinkedHashMap();
            }
            this(map2, function1);
        }

        @NotNull
        public final Function1<K, V> getDefault() {
            return this.default;
        }

        @NotNull
        public Set<Map.Entry<K, V>> getEntries() {
            return this.map.entrySet();
        }

        @NotNull
        public Set<K> getKeys() {
            return this.map.keySet();
        }

        public int getSize() {
            return this.map.size();
        }

        @NotNull
        public Collection<V> getValues() {
            return this.map.values();
        }

        @Override
        public boolean containsValue(Object value2) {
            return this.map.containsValue(value2);
        }

        @Override
        @Nullable
        public V get(Object key) {
            Object object;
            Map<Object, Object> $this$getOrPut$iv = this.map;
            boolean $i$f$getOrPut = false;
            V value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                Object answer$iv = this.getDefault().invoke(key);
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return object;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V compute(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfAbsent(K p0, Function<? super K, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfPresent(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V merge(K p0, V p1, BiFunction<? super V, ? super V, ? extends V> p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V put(K key, V value2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> from) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V putIfAbsent(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object key, Object value2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean replace(K p0, V p1, V p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V replace(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$Companion;", "", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcIdentifierManager;", "identityManagerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "<init>", "()V", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

